/* -*- tab-width: 4 -*-
 *
 * Electric(tm) VLSI Design System
 *
 * File: GerberTab.java
 *
 * Copyright (c) 2010, Static Free Software. All rights reserved.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.sun.electric.tool.user.dialogs.options;

import com.sun.electric.tool.io.IOTool;

import com.sun.electric.tool.user.dialogs.PreferencesFrame;

import javax.swing.JPanel;

/**
 * Class to handle the "Gerber" tab of the Preferences dialog.
 */
public class GerberTab extends PreferencePanel
{
	/** Creates new form GerberTab */
	public GerberTab(PreferencesFrame parent, boolean modal)
	{
		super(parent, modal);
		initComponents();
	}

	/** return the panel to use for user preferences. */
	public JPanel getUserPreferencesPanel() { return gerber; }

	/** return the name of this preferences tab. */
	public String getName() { return "Gerber"; }

	/**
	 * Method called at the start of the dialog.
	 * Caches current values and displays them in the Gerber tab.
	 */
	public void init()
	{
		gerberFillPolygons.setSelected(IOTool.isGerberFillsPolygons());
		gerberReadAllFiles.setSelected(IOTool.isGerberReadsAllFiles());
	}

	/**
	 * Method called when the "OK" panel is hit.
	 * Updates any changed fields in the Gerber tab.
	 */
	public void term()
	{
		boolean currentBoolean = gerberFillPolygons.isSelected();
		if (currentBoolean != IOTool.isGerberFillsPolygons())
			IOTool.setGerberFillsPolygons(currentBoolean);

		currentBoolean = gerberReadAllFiles.isSelected();
		if (currentBoolean != IOTool.isGerberReadsAllFiles())
			IOTool.setGerberReadsAllFiles(currentBoolean);
	}

	/**
	 * Method called when the factory reset is requested.
	 */
	public void reset()
	{
		if (IOTool.isFactoryGerberFillsPolygons() != IOTool.isGerberFillsPolygons())
			IOTool.setGerberFillsPolygons(IOTool.isFactoryGerberFillsPolygons());
		if (IOTool.isFactoryGerberReadsAllFiles() != IOTool.isGerberReadsAllFiles())
			IOTool.setGerberReadsAllFiles(IOTool.isFactoryGerberReadsAllFiles());
	}

	/** This method is called from within the constructor to
	 * initialize the form.
	 * WARNING: Do NOT modify this code. The content of this method is
	 * always regenerated by the Form Editor.
	 */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        gerber = new javax.swing.JPanel();
        gerberFillPolygons = new javax.swing.JCheckBox();
        gerberReadAllFiles = new javax.swing.JCheckBox();

        setTitle("IO Options");
        setName(""); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        getContentPane().setLayout(new java.awt.GridBagLayout());

        gerber.setLayout(new java.awt.GridBagLayout());

        gerberFillPolygons.setText("Fill polygons");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        gerber.add(gerberFillPolygons, gridBagConstraints);

        gerberReadAllFiles.setText("Read all .GBR files in the directory");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        gerber.add(gerberReadAllFiles, gridBagConstraints);

        getContentPane().add(gerber, new java.awt.GridBagConstraints());

        pack();
    }// </editor-fold>//GEN-END:initComponents

	/** Closes the dialog */
	private void closeDialog(java.awt.event.WindowEvent evt)//GEN-FIRST:event_closeDialog
	{
		setVisible(false);
		dispose();
	}//GEN-LAST:event_closeDialog

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel gerber;
    private javax.swing.JCheckBox gerberFillPolygons;
    private javax.swing.JCheckBox gerberReadAllFiles;
    // End of variables declaration//GEN-END:variables

}
